{
mviewer.customLayers.cinema_actif = {};
var cinema_actif = mviewer.customLayers.cinema_actif;


let styleArtsetEssais = [
  new ol.style.Style({
    image: new ol.style.Circle({
      fill: new ol.style.Fill({
        color: "#002a00",
      }),
      stroke: new ol.style.Stroke({
        color: "#ffffff",
        width: 1,
      }),
      radius: 9,
    }),
  }),
];

let styleNonArtsetEssais = [
  new ol.style.Style({
    image: new ol.style.Circle({
      fill: new ol.style.Fill({
		color: "#ff2aff",
      }),
      stroke: new ol.style.Stroke({
        color: "#ffffff",
        width: 1,
      }),
      radius: 9,
    }),
  }),
];

cinema_actif.legend = {items: [{
		geometry: "Point",
		label: "Arts et essais",
		styles: [new ol.style.Style({
			image: new ol.style.Circle({
				fill: new ol.style.Fill({
					color: "#002a00"
				}),
				stroke: new ol.style.Stroke({
					color: "#ff2a00",
					width: 1
				}),
				radius: 4
			})
		})]
	},
	{
		geometry: "Point",
		label: "Non Arts et essais",
		styles: [new ol.style.Style({
			image: new ol.style.Circle({
				fill: new ol.style.Fill({
					color: "#ff2aff"
				}),
				stroke: new ol.style.Stroke({
					color: "#ff2a00",
					width: 1
				}),
				radius: 4
			})
		})]
	}	
	]
	
};

//
// Appel de la source de donnée et affichage du style sur la carte
mviewer.customLayers.cinema_actif.layer = new ol.layer.Vector({
        source: new ol.source.Vector({
            url: "https://www.datagrandest.fr/geoserver/region-grand-est/wfs?request=GetFeature&service=WFS&version=1.1.0&typeName=cinema_actif&srsName=EPSG:4326&outputFormat=application/json",
            format: new ol.format.GeoJSON()
        }),
        style: function(feature, resolution) {
				var stl;
				if (feature.get("ae_txt") === "Arts et essais") {
				  stl = styleArtsetEssais;
				} else if (
				  feature.get("ae_txt") === "Non Arts et essais"
				) {
				  stl = styleNonArtsetEssais;
				}

			return stl;
			//return cinema_actif.legend.items[0].styles;
        }
});
mviewer.customLayers.cinema_actif.handle = false;
} 
