mviewer.customLayers.luminaire = (function () {
    _filter = false;
    _ready = false;
    _mode = "AND"; /*AND | OR*/
    _maxfeatures = 5000;
    _maxrequestedfeatures = 50;
    _featurescount = null;
    _searchinfields = ["ident", "commune", "insee"];

    var els2GeoJSON = function (data) {
        var geojson = {
            "type": "FeatureCollection",
            "features": []
        };
        var getProperties = function (source) {
            var properties = {};
            for (var propertyName in source) {
                if (["geometry", "@timestamp", "@version"].indexOf(propertyName) === -1) {
                    properties[propertyName] = source[propertyName];
                }
            }
            return properties;
        };
        data.hits.hits.forEach(function (item) {
            var properties = getProperties(item._source);
            var prop = {};
            prop.source = "SDED52";
            properties.type = item._type;
            properties.source = prop.source;
            var feature = {
                "type": "Feature",
                "id": item._id,
                "geometry": item._source.geometry,
                "properties": properties
            };
            geojson.features.push(feature);
        });
        return JSON.stringify(geojson);
    };

    var elsLoader = function (extent, resolution, projection) {
        var filter = {
            "match_all": {}
        };
        if (_filter) {
            var matchQueries = [];
            _filter.forEach(function (text) {
                var matchQuery = {
                    "match": {
                        "_all": {
                            "query": text,
                            "operator": "and"
                        }
                    }
                };
                if (_searchinfields.length > 0) {
                    matchQuery = {
                        "multi_match": {
                            "query": text,
                            "operator": "and",
                            "fields": _searchinfields
                        }
                    };
                }
                matchQueries.push(matchQuery);
            });
            filter = {
                "bool": {
                    "should": matchQueries,
                    "minimum_should_match": (_mode === "AND") ? matchQueries.length : 1
                }
            };
        }
        var proj = projection.getCode();
        var e = ol.proj.transformExtent(extent, proj, 'EPSG:4326');
        var url = "https://els.sded52.fr/mviewer/_search?";
        var geofilter = JSON.stringify({
            "from": 0,
            "size": 5000,
            "query": {


                "filter": {
                    "geo_shape": {
                        "geometry": {
                            "shape": {
                                "type": "envelope",
                                "coordinates": [
                                    [e[0], e[1]],
                                    [e[2], e[3]]
                                ]
                            }
                        }
                    }
                }

            }
        });
        var xhr = new XMLHttpRequest();
        xhr.open('POST', url);
        // xhr.overrideMimeType("application/json;charset=UTF-8");
        xhr.setRequestHeader('Content-Type', 'application/json');
        var onError = function () {
            vectorSource.removeLoadedExtent(extent);
        }
        xhr.onerror = onError;
        xhr.onload = function () {
            if (xhr.status == 200) {
                vectorSource.addFeatures(
                    new ol.format.GeoJSON().readFeatures(els2GeoJSON(JSON.parse(xhr.responseText)), {
                        dataProjection: 'EPSG:4326',
                        featureProjection: proj
                    })
                );
            } else {
                onError();
            }
        }
        xhr.send(geofilter);
    };





    _legend = {
        items: []
    };
    var styleBF = [new ol.style.Style({
        image: new ol.style.Circle({
            fill: new ol.style.Fill({
                color: "#ff0000"
            }),
            stroke: new ol.style.Stroke({
                color: "#ff0000",
                width: 4
            }),
            radius: 4
        })
    })];

    var styleSHP = [new ol.style.Style({
        image: new ol.style.Circle({
            fill: new ol.style.Fill({
                color: "#ff9900"
            }),
            stroke: new ol.style.Stroke({
                color: "#ff9900",
                width: 4
            }),
            radius: 4
        })
    })];

    var styleCPO = [new ol.style.Style({
        image: new ol.style.Circle({
            fill: new ol.style.Fill({
                color: "#0000cc"
            }),
            stroke: new ol.style.Stroke({
                color: "#0000cc",
                width: 4
            }),
            radius: 4
        })
    })];

    var styleIM = [new ol.style.Style({
        image: new ol.style.Circle({
            fill: new ol.style.Fill({
                color: "#3399ff"
            }),
            stroke: new ol.style.Stroke({
                color: "#3399ff",
                width: 4
            }),
            radius: 4
        })
    })];

    var styleDefaut = [new ol.style.Style({
        image: new ol.style.Circle({
            fill: new ol.style.Fill({
                color: "#000000"
            }),
            stroke: new ol.style.Stroke({
                color: "#000000",
                width: 4
            }),
            radius: 4
        })
    })];

    _legend.items.push({
        styles: styleBF,
        label: "Ballon Fluo",
        geometry: "Point"
    });
    _legend.items.push({
        styles: styleSHP,
        label: "SHP",
        geometry: "Point"
    });
    _legend.items.push({
        styles: styleCPO,
        label: "CPO",
        geometry: "Point"
    });
    _legend.items.push({
        styles: styleIM,
        label: "IM",
        geometry: "Point"
    });
    _legend.items.push({
        styles: styleDefaut,
        label: "Defaut",
        geometry: "Point"
    });



    var typeStyle = function (feature) {
        var stl;
        if (feature.get('Type de lampe') === 'B.F.') {
            stl = styleBF;
        } else if (feature.get('Type de lampe') === 'SHP') {
            stl = styleSHP;
        } else if (feature.get('Type de lampe') === 'CPO') {
            stl = styleCPO;
        } else if (feature.get('Type de lampe') === 'IM') {
            stl = styleIM;
        } else stl = styleDefaut
        return stl;
    };



    var vectorSource = new ol.source.Vector({
        loader: elsLoader,
        strategy: ol.loadingstrategy.bbox
    });

    var _layer = new ol.layer.Vector({
        source: vectorSource,
        style: typeStyle
    });
    var _handle = function (features, views) {
        var extraTemplate = [
            '<p class="text-feature">',
            '{{#ident}}',
            '<span > Identifiant :</span> {{ident}}<br/>',
            '{{/ident}}',
            '<span > Commune : </span>{{Commune}}<br/>'
        ].join(" ");
        var _extendHTML = function (wfsfeatures) {
            wfsfeatures.forEach(function (wfsfeature, i) {
                var html = Mustache.render(extraTemplate, wfsfeature.properties);
                $(document.getElementById(wfsfeature.properties.search_id)).append(html);
            });

        };

        var _renderHTML = function (elements) {
            var l = mviewer.getLayer("luminaire");
            var html;
            if (l.template) {
                html = info.templateHTMLContent(elements, l);
            } else {
                html = info.formatHTMLContent(elements, l);
            }
            var view = views["right-panel"];
            view.layers.push({
                "id": view.layers.length + 1,
                "firstlayer": true,
                "manyfeatures": (features.length > 1),
                "nbfeatures": features.length,
                "name": l.name,
                "layerid": "luminaire",
                "theme_icon": l.icon,
                "html": html
            });
        };
        _renderHTML(features);
    };

    return {
        layer: _layer,
        handle: _handle,
        legend: _legend,
        mode: _mode,
        setFilter: function (val) {
            _filter = val;
            _ready = true;
        },
        getFilter: function () {
            return _filter;
        }
    };

}());