{
    mviewer.customLayers.cluster = {};
    var cl = mviewer.customLayers.cluster;
    cl.legend = { items:[] };
	
    var ouvert = [
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 10,
                fill: new ol.style.Fill({
                    color: 'rgba( 255, 255, 255, 0.7)'
                })
            })
        }),
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 8,
                fill: new ol.style.Fill({
                    color: '#6e8225'
                })
            })
        })
    ];
    var ouvert_adapte = [
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 10,
                fill: new ol.style.Fill({
                    color: 'rgba( 255, 255, 255, 0.7)'
                })
            })
        }),
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 8,
                fill: new ol.style.Fill({
                    color: '#9fb935'
                })
            })
        })
    ];
    var ouvert_partiel = [
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 10,
                fill: new ol.style.Fill({
                    color: 'rgba( 255, 255, 255, 0.7)'
                })
            })
        }),
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 8,
                fill: new ol.style.Fill({
                    color: '#e3c213'
                })
            })
        })
    ];
    var ferme = [
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 10,
                fill: new ol.style.Fill({
                    color: 'rgba( 255, 255, 255, 0.7)'
                })
            })
        }),
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 8,
                fill: new ol.style.Fill({
                    color: '#b0252e'
                })
            })
        })
    ];
    var inconnue = [
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 10,
                fill: new ol.style.Fill({
                    color: 'rgba( 255, 255, 255, 0.7)'
                })
            })
        }),
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 8,
                fill: new ol.style.Fill({
                    color: '#4c74b5'
                })
            })
        })
    ];	

    /*var uniqueStyle = [
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 10,
                fill: new ol.style.Fill({
                    color: 'rgba( 255, 255, 255, 0.7)'
                })
            })
        }),
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 8,
                fill: new ol.style.Fill({
                    color: 'rgba(38, 97, 156,7.0)'
                })
            })
        })
    ];	*/

    var manyStyle = function (radius, radius2, size) {
        return [
            new ol.style.Style({
                image: new ol.style.Circle({
                    radius: radius,
                    fill: new ol.style.Fill({
                        color: 'rgba(38, 97, 156,0.7)'
                    })
                }),
                stroke: new ol.style.Stroke({
                    color: 'red',
                    width: 3
              }),
              fill: new ol.style.Fill({
                color: 'rgba(0, 0, 255, 0.1)'
              })
            }),
            new ol.style.Style({
                image: new ol.style.Circle({
                    radius: radius2,
                    fill: new ol.style.Fill({
                        color: 'rgba(38, 97, 156,0.7)'
                    })
                }),
                text: new ol.style.Text({
                    font: '12px roboto_regular, Arial, Sans-serif',
                    text: size.toString(),
                    fill: new ol.style.Fill({
                        color: '#fff'
                    })
                })
            })
        ];
    };
	
	
    cl.legend.items.push({styles:ouvert, label: "Ouvert", geometry: "Point"});
    cl.legend.items.push({styles:ouvert_adapte, label: "Ouverture adaptée", geometry: "Point"});
    cl.legend.items.push({styles:ouvert_partiel, label: "Ouverture partielle", geometry: "Point"});
    cl.legend.items.push({styles:ferme, label: "Fermé", geometry: "Point"});
    cl.legend.items.push({styles:inconnue, label: "Ouverture Inconnue", geometry: "Point"});

    var styleUnique = function(feature) {
        var stl;
			switch(feature.get('famille')){
				case 'Ouvert':
					stl =  ouvert;
					break;
				case 'ouvert_adapté':
					stl = ouvert_adapte;
					break;
				case 'partiel':
					stl = ouvert_partiel;
					break;
				case 'fermé':
					stl = ferme;
					break;
				case 'inconnu':
					stl = inconnue;
					break;
			}
        return stl;
    };


    var clusterStyle = function(feature) {
		var zoom = mviewer.getMap().getView().getZoom();
        var size = feature.get('features').length;
        var max_radius = 20;
        var max_value = 100;
        var radius = 10 + Math.sqrt(size)*(max_radius / Math.sqrt(max_value));
        var radius2 = radius *80 /100 ;
        if (size == 1 || zoom == 19) 
			{
			return styleUnique(feature.getProperties().features[0]);
        } else {
            return manyStyle(radius, radius2, size);
        }
    };

    cl.layer = new ol.layer.Vector({
        source: new ol.source.Cluster({
            distance: 50,
            source: new ol.source.Vector({
				url: "https://geobretagne.fr/geoserver/osm/wfs?service=WFS&version=1.0.0&request=GetFeature&typeNames=caresteouvert&outputFormat=application/json&srsName=EPSG:4326&CQL_FILTER=region='BRETAGNE'",
                format: new ol.format.GeoJSON()
            })
        }),
        style: clusterStyle

    });
    cl.handle = function(clusters, views) {
        if (clusters.length > 0 && clusters[0].properties.features) {
            var features = clusters[0].properties.features;
            var elements = [];
            var l = mviewer.getLayer("cluster");
            features.forEach(function(feature, i) {
                elements.push({
                    properties: feature.getProperties()
                });
            });
            var html;
            if (l.template) {
                html = info.templateHTMLContent(elements, l);
            } else {
                html = info.formatHTMLContent(elements, l);
            }
            var panel = "";
            if (configuration.getConfiguration().mobile) {
                panel = "modal-panel";
            } else {
                panel = "right-panel"
            }
            var view = views[panel];			
            view.layers.push({
                "id": view.layers.length + 1,
                "firstlayer": true,
                "manyfeatures": (features.length > 1),
                "nbfeatures": features.length,
                "name": l.name,
                "layerid": "cluster",
                "theme_icon": l.icon,
                "html": html
            });
        }

    };
}