<!DOCTYPE html>
<html lang="en">

<head>

  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="">
  <meta name="author" content="">

  <title>DVF - Dashboard</title>

  <!-- Custom fonts for this template-->
  <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">

  <!-- Page level plugin CSS-->
  <link href="vendor/datatables/dataTables.bootstrap4.css" rel="stylesheet">

  <!-- Custom styles for this template-->
  <link href="css/sb-admin.css" rel="stylesheet">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css"> 
	<script src="https://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/angular-filter/0.5.17/angular-filter.min.js"></script>
        <script src="../js/gec_include.js"></script>

</head>

<body id="page-top">



<script>
		const urlParams = new URLSearchParams(window.location.search);
		const code_departement =  urlParams.get('code_departement');
		const code_commune = urlParams.get('code_commune');
		const nature_mutation = urlParams.get('nature_mutation');
		const date_mutation = urlParams.get('date_mutation');
		const valeur_fonciere = urlParams.get('valeur_fonciere');
		const no_disposition = urlParams.get('no_disposition');




		$url = 'https://www.geograndest.fr/geoserver/region-grand-est/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=region-grand-est:dvf_final_geoloc&maxFeatures=50&outputFormat=application/json&CQL_FILTER=(code_commune='+code_commune+')and(code_departement='+code_departement+')and(nature_mutation=\''+nature_mutation+'\')and(date_mutation=\''+date_mutation+'\')and(valeur_fonciere='+valeur_fonciere+')and(no_disposition='+no_disposition+')';  
</script>


  <nav class="navbar navbar-expand navbar-dark bg-dark static-top">

    <a class="navbar-brand mr-1" href="">Mutation</a>

    <button class="btn btn-link btn-sm text-white order-1 order-sm-0" id="sidebarToggle" href="#">
      <i class="fas fa-bars"></i>
    </button>

  

  </nav>

  <div id="wrapper">

    <!-- Sidebar -->
    <ul class="sidebar navbar-nav">
      <li class="nav-item active">
        <a class="nav-link" href="">
          <i class="fas fa-fw fa-tachometer-alt"></i>
          <span>Dashboard</span>
        </a>
      </li>
    </ul>

    <div id="">

      <div class="container-fluid">

        <!-- Breadcrumbs-->
        <ol class="breadcrumb">
          <li class="breadcrumb-item">
            <a href="#">Dashboard</a>
          </li>
          <li class="breadcrumb-item active">Overview</li>
        </ol>

        <!-- Icon Cards-->
        <div class="row">
          <div class="col-xl-3 col-sm-6 mb-3">
            <div class="card text-white bg-primary o-hidden h-100">
              <div class="card-body">
                <div class="card-body-icon">
                   <i class="fas fa-calendar-alt"></i>
                </div>
                <div class="mr-5">Date de la mutation</div>
                <div class="mr-5"><p id="p1">Date</p></div>
              </div>
            </div>
          </div>
          <div class="col-xl-3 col-sm-6 mb-3">
            <div class="card text-white bg-warning o-hidden h-100">
              <div class="card-body">
                <div class="card-body-icon">
                  <i class="fas fa-euro-sign"></i>
                </div>
                <div class="mr-5">Valeur foncière</div>
                <div class="mr-5"><p id="p2">Valeur</p></div>
              </div>
              </a>
            </div>
          </div>
          <div class="col-xl-3 col-sm-6 mb-3">
            <div class="card text-white bg-success o-hidden h-100">
              <div class="card-body">
                <div class="card-body-icon">
                  <i class="fas fa-fw fa-list"></i>
                </div>
                <div class="mr-5">Code commune</div>
                <div class="mr-5"><p id="p3">code</p></div>
              </div>
            </div>
          </div>
          <div class="col-xl-3 col-sm-6 mb-3">
            <div class="card text-white bg-danger o-hidden h-100">
              <div class="card-body">
                <div class="card-body-icon">
                  <i class="fas fa-fw fa-home"></i>
                </div>
                <div class="mr-5">Nature de la mutation</div>
                <div class="mr-5"><p id="p4">nature</p></div>
              </div>
            </div>
          </div>

        </div>


        <!-- DataTables Example -->
        <div class="card mb-3">
          <div class="card-header">
            <i class="fas fa-table"></i>
            Détail de la mutation</div>
          <div class="card-body">
            <div ng-app="serviceApp" ng-controller="serviceCtrl" class="table-responsive">
              <table class="table table-bordered" id="" width="100%" cellspacing="0">
                <thead>
      <tr>
         <th>Préfixe section</th>
         <th>Section</th>
         <th>Parcelle</th>
         <th>Surface parcelle</th>
         <th>Nature culture<a href="https://static.data.gouv.fr/resources/demande-de-valeurs-foncieres/20190419-091804/tables-de-reference-nature-de-culture.pdf" target="_blank"> (?)</a></th>
         <th>Surface bati</th>
         <th>Type de local</th>
         <th>Nombre de lots</th>
         <th>Nombre de pièces principales</th>
         <th>Surf du 1er lot</th>
         <th>Surf du 2ème lot</th>
         <th>Surf du 3ème lot</th>
         <th>Surf du 4ème lot</th>
         <th>Surf du 5ème lot</th>
     </tr>
                </thead>
     <tbody>
      <tr ng-repeat="row in myData">
         <td width=14%>{{ row.properties.prefixe_de_section }}</td>
         <td width=14%>{{ row.properties.section }}</td>
         <td width=14%>{{ row.properties.no_plan}}</td>
         <td width=14%>{{ row.properties.surface_terrain}}</td>
         <td width=14%>{{ row.properties.nature_culture}}</td>
         <td width=14%>{{ row.properties.surface_reelle_bati}}</td>
         <td width=14%>{{ row.properties.type_local}}</td>
         <td width=14%>{{ row.properties.nombre_de_lots}}</td>
         <td width=14%>{{ row.properties.nombre_pieces_principales}}</td>
         <td width=14%>{{ row.properties.surface_carrez_du_1er_lot}}</td>
         <td width=14%>{{ row.properties.surface_carrez_du_2eme_lot}}</td>
         <td width=14%>{{ row.properties.surface_carrez_du_3eme_lot}}</td>
         <td width=14%>{{ row.properties.surface_carrez_du_4eme_lot}}</td>
         <td width=14%>{{ row.properties.surface_carrez_du_5eme_lot}}</td>

      </tr>
    </tbody>

              </table>
            </div>
          </div>
          <div class="card-footer small text-muted"></div>
        </div>

      </div>

      <!-- Sticky Footer -->
      <footer class="sticky-footer">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright © Your Website 2019</span>
          </div>
        </div>
      </footer>

    </div>
    <!-- /.content-wrapper -->

  </div>
  <!-- /#wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>

  </div>

  <!-- Bootstrap core JavaScript-->
  <script src="vendor/jquery/jquery.min.js"></script>
  <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

  <!-- Core plugin JavaScript-->
  <script src="vendor/jquery-easing/jquery.easing.min.js"></script>

  <!-- Page level plugin JavaScript-->
  <script src="vendor/chart.js/Chart.min.js"></script>
  <script src="vendor/datatables/jquery.dataTables.js"></script>
  <script src="vendor/datatables/dataTables.bootstrap4.js"></script>

  <!-- Custom scripts for all pages-->
  <script src="js/sb-admin.min.js"></script>

  <!-- Demo scripts for this page-->
  <script src="js/demo/datatables-demo.js"></script>
  <script src="js/demo/chart-area-demo.js"></script>

<script>
document.getElementById("p1").innerHTML = date_mutation;
document.getElementById("p2").innerHTML = valeur_fonciere+' €';
document.getElementById("p3").innerHTML = code_departement+code_commune ;
document.getElementById("p4").innerHTML = nature_mutation;



</script>


</body>

</html>

