mviewer.customLayers.luminaire_langres = (function () {
    _filter = false;
    _ready = false;
    _mode = "AND"; /*AND | OR*/
    _maxfeatures = 80000;
    _maxrequestedfeatures = 50;
    _featurescount = null;
    _searchinfields = ["ident"];

    var els2GeoJSON = function (data) {
        var geojson = {
            "type": "FeatureCollection",
            "features": []
        };
        var getProperties = function (source) {
            var properties = {};
            for (var propertyName in source) {
                if (["geometry", "@timestamp", "@version"].indexOf(propertyName) === -1) {
					if (["Date de pose de la lampe","Date de pose appareillage"].indexOf(propertyName) === -1){
						properties[propertyName] = source[propertyName];
					}
					else { properties[propertyName] = String(source[propertyName]).substr(0,10);
					}
				}    
            }
            return properties;
        };
		
        data.hits.hits.forEach(function (item) {
			
            var properties = getProperties(item._source);
            var prop = {};
            properties.type = item._type;
            properties.source = "SDED52";
            var feature = {
                "type": "Feature",
                "id": item._id,
                "geometry": item._source.geometry,
                "properties": properties
            };
            geojson.features.push(feature);
        });
        return JSON.stringify(geojson);
    };

    var _elsLoader = function (extent, resolution, projection) {
        var filter = {
            "match_all": {}
        };
        if (_filter) {
            var matchQueries = [];
            _filter.forEach(function (text) {
                var matchQuery = {
                    "match": {
                        "_all": {
                            "query": text,
                            "operator": "and"
                        }
                    }
                };
                if (_searchinfields.length > 0) {
                    matchQuery = {
                        "multi_match": {
                            "query": text,
                            "operator": "and",
                            "fields": _searchinfields
                        }
                    };
                }
                matchQueries.push(matchQuery);
            });
            filter = {
                "bool": {
                    "should": matchQueries,
                    "minimum_should_match": (_mode === "AND") ? matchQueries.length : 1
                }
            };
        }
        var proj = projection.getCode();
        var e = ol.proj.transformExtent(extent, proj, 'EPSG:4326');
        var url = "https://els.sded52.fr/mviewer/_search?track_total_hits=true";
		var date = new Date();
		var day = date.getDate();
		var month = date.getMonth()+1;
		var year = date.getFullYear();
		var dDay = day + '_' + month + '_' + year;
        var geofilter = JSON.stringify({
            "from": 0,
            "size":  70000, //(_ready)? _maxfeatures: 10,,
            "query": {
				"bool": {
				"must": [
                        filter,
                        {            				  
                               
                            "type": {
									"value": "_doc"
                                    }
						},
							{            				  
                               
                            "term": {
									"date_import": dDay									
                                    },
							"term": {
									"insee": "052269"
									}
						}
					
					/*
					
					
					{
								"query_string":{
									"query" : dDay,
									"default_field" : "date_import"
									}
								
					}*/
					
					
					]			
                                
                            
							
				}   
                
            }
            
        });
		
		
		
		
		
		
		
		
		
		
        var xhr = new XMLHttpRequest();
        xhr.open('POST', url);
        // xhr.overrideMimeType("application/json;charset=UTF-8");
        xhr.setRequestHeader('Content-Type', 'application/json');
        var onError = function () {
            _vectorSource.removeLoadedExtent(extent);
        }
        xhr.onerror = onError;
        xhr.onload = function () {
            if (xhr.status == 200) {
				/*var json = JSON.parse(xhr.responseText);
                var message = "* Affichage complet - " + json.hits.total + " éléments";
               
                _featurescount = json.hits.hits.length;
                $("#inventaire_search_message i").text(message);*/
                _vectorSource.addFeatures(
                    new ol.format.GeoJSON().readFeatures(els2GeoJSON(JSON.parse(xhr.responseText)), {
                       // dataProjection: 'EPSG:4326',
                        featureProjection: proj
                    })
                );
            } else {
                onError();
            }
        }
        xhr.send(geofilter);
    };





    _legend = {
        items: []
    };
    var styleBF = [new ol.style.Style({
        image: new ol.style.Circle({
            fill: new ol.style.Fill({
                color: "#ff0000"
            }),
            stroke: new ol.style.Stroke({
                color: "#ff0000",
                width: 4
            }),
            radius: 4
        })
    })];

    var styleSHP = [new ol.style.Style({
        image: new ol.style.Circle({
            fill: new ol.style.Fill({
                color: "#ff9900"
            }),
            stroke: new ol.style.Stroke({
                color: "#ff9900",
                width: 4
            }),
            radius: 4
        })
    })];

    var styleCPO = [new ol.style.Style({
        image: new ol.style.Circle({
            fill: new ol.style.Fill({
                color: "#0000cc"
            }),
            stroke: new ol.style.Stroke({
                color: "#0000cc",
                width: 4
            }),
            radius: 4
        })
    })];

    var styleIM = [new ol.style.Style({
        image: new ol.style.Circle({
            fill: new ol.style.Fill({
                color: "#3399ff"
            }),
            stroke: new ol.style.Stroke({
                color: "#3399ff",
                width: 4
            }),
            radius: 4
        })
    })];
	
	 var styleLED = [new ol.style.Style({
        image: new ol.style.Circle({
            fill: new ol.style.Fill({
                color: "#33ff33"
            }),
            stroke: new ol.style.Stroke({
                color: "#33ff33",
                width: 4
            }),
            radius: 4
        })
    })];

    var styleDefaut = [new ol.style.Style({
        image: new ol.style.Circle({
            fill: new ol.style.Fill({
                color: "#000000"
            }),
            stroke: new ol.style.Stroke({
                color: "#000000",
                width: 4
            }),
            radius: 4
        })
    })];

    _legend.items.push({
        styles: styleBF,
        label: "Ballon Fluo",
        geometry: "Point"
    });
    _legend.items.push({
        styles: styleSHP,
        label: "SHP",
        geometry: "Point"
    });
    _legend.items.push({
        styles: styleCPO,
        label: "CPO",
        geometry: "Point"
    });
    _legend.items.push({
        styles: styleIM,
        label: "IM",
        geometry: "Point"
    });
	_legend.items.push({
        styles: styleLED,
        label: "LED",
        geometry: "Point"
    });
    _legend.items.push({
        styles: styleDefaut,
        label: "Defaut",
        geometry: "Point"
    });



    var typeStyle = function (feature) {
        var stl;
        if (feature.get('Type de lampe') === 'B.F.') {
            stl = styleBF;
        } else if (feature.get('Type de lampe') === 'SHP') {
            stl = styleSHP;
        } else if (feature.get('Type de lampe') === 'CPO') {
            stl = styleCPO;
        } else if (feature.get('Type de lampe') === 'IM') {
            stl = styleIM;
        } else if (feature.get('Type de lampe') === 'LED') {
            stl = styleLED;
		} else stl = styleDefaut
        return stl;
    };



    var _vectorSource = new ol.source.Vector({
        loader: _elsLoader,
        strategy: ol.loadingstrategy.bbox
    });

    var _layer = new ol.layer.Vector({
        source: _vectorSource,
        style: typeStyle
    });
    var _handle = function (features, views) {
       
		if  ($("#wrapper").hasClass("xs mode-d")) { 
			  var _renderHTML = function (elements) {
            var l = mviewer.getLayer("luminaire_langres");
            var html;
            if (l.template) {
                html = info.templateHTMLContent(elements, l);
            } else {
                html = info.formatHTMLContent(elements, l);
            }
            var view = views["modal-panel"];
            view.layers.push({
                "id": view.layers.length + 1,
                "firstlayer": true,
                "manyfeatures": (features.length > 1),
                "nbfeatures": features.length,
                "name": l.name,
                "layerid": "luminaire_langres",
                "theme_icon": l.icon,
                "html": html
            });
        };
		}
		else {		
			var _renderHTML = function (elements) {
				var l = mviewer.getLayer("luminaire_langres");
				var html;
				if (l.template) {
					html = info.templateHTMLContent(elements, l);
				} else {
					html = info.formatHTMLContent(elements, l);
				}
				var view = views["right-panel"];
				view.layers.push({
					"id": view.layers.length + 1,
					"firstlayer": true,
					"manyfeatures": (features.length > 1),
					"nbfeatures": features.length,
					"name": l.name,
					"layerid": "luminaire_langres",
					"theme_icon": l.icon,
					"html": html
				});
			};
			
		};
		
        _renderHTML(features);
    };

    return {
        layer: _layer,
        handle: _handle,
        legend: _legend,
        mode: _mode,
        setFilter: function (val) {
            _filter = val;
            _ready = true;
        },
        getFilter: function () {
            return _filter;
        }
    };

}());