mviewer.customControls.luminaire_langres = (function() {
    /*
     * Private
     */
    var _idlayer = 'luminaire_langres';

    var _zoomlevel = false;

    var _defaultValue = '';

    var _lastValues = false;

    var _collection = false;

    var _updateLayer = function() {
        var values = $("#luminaire_langres_search_queries").tagsinput('items') || [];
        mviewer.customLayers.luminaire_langres.setFilter(values);
		// mviewer.customLayers.inventaire.layer.getSource().getSource().clear(false);
        mviewer.customLayers.luminaire_langres.layer.getSource().refresh();
        mviewer.customLayers.luminaire_langres.layer.getSource().changed();
        _lastValues = values.join(",");
    };

    var _mapChanged = function (e) {
        var newZoomlevel = mviewer.getMap().getView().getZoom();
        if ( _zoomlevel && (newZoomlevel > _zoomlevel)) {
            _updateLayer();
        }
        _zoomlevel = newZoomlevel;
    };

    var _initForm = function () {
        $("#luminaire_langres_search_queries").tagsinput({
            typeahead: {
                source: _collection
            },
            freeInput: false,
            tagClass: 'label label-mv'
        });
        if (_defaultValue && !_lastValues) {
            $("#luminaire_langres_search_queries").tagsinput("add", _defaultValue);
            _defaultValue = false;
            _updateLayer();
        } else if (_lastValues) {
            $("#luminaire_langres_search_queries").tagsinput("add", _lastValues);
            _defaultValue = false;
            _updateLayer();
        }
        $("#luminaire_langres_search_queries").on('itemAdded', function(event) {
            _updateLayer();
            setTimeout(function(){
                $(">input[type=text]",".bootstrap-tagsinput").val("");
            }, 1);
        });
        $("#luminaire_langres_search_queries").on('itemRemoved', function(event) {
            _updateLayer();
        });
    };



    return {
        /*
         * Public
         */

        init: function() {
            // mandatory - code executed when panel is opened
            if (!_collection) {
                $.getJSON("https://www.geograndest.fr/mviewer/partenaires/ca-chaumont/collection_langres.json", function(data){
                    _collection = data;
                    _initForm();
                });
            } else {
                _initForm();
            }
            mviewer.getMap().on('moveend', _mapChanged);


        },

        destroy: function() {
            // mandatory - code executed when panel is closed
            $("#luminaire_langres_search_queries").tagsinput('removeAll');
            mviewer.getMap().un('moveend', _mapChanged);

        }
    };

}());