{
    mviewer.customLayers.cluster = {};
    var cl = mviewer.customLayers.cluster;
    cl.legend = { items:[] };
	
    var supermarche = [
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 10,
                fill: new ol.style.Fill({
                    color: 'rgba( 255, 255, 255, 0.7)'
                })
            })
        }),
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 8,
                fill: new ol.style.Fill({
                    color: 'rgba(255, 228, 54,7.0)'
                })
            })
        })
    ];
    var pharmacie = [
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 10,
                fill: new ol.style.Fill({
                    color: 'rgba( 255, 255, 255, 0.7)'
                })
            })
        }),
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 8,
                fill: new ol.style.Fill({
                    color: 'rgba(20, 148, 20,7.0)'
                })
            })
        })
    ];
    var alimentaire = [
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 10,
                fill: new ol.style.Fill({
                    color: 'rgba( 255, 255, 255, 0.7)'
                })
            })
        }),
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 8,
                fill: new ol.style.Fill({
                    color: 'rgba(237, 127, 16,7.0)'
                })
            })
        })
    ];
    var tabac_journaux = [
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 10,
                fill: new ol.style.Fill({
                    color: 'rgba( 255, 255, 255, 0.7)'
                })
            })
        }),
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 8,
                fill: new ol.style.Fill({
                    color: 'rgba(167, 85, 2,7.0)'
                })
            })
        })
    ];
    var laverie = [
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 10,
                fill: new ol.style.Fill({
                    color: 'rgba( 255, 255, 255, 0.7)'
                })
            })
        }),
        new ol.style.Style({
            image: new ol.style.Circle({
                radius: 8,
                fill: new ol.style.Fill({
                    color: 'rgba(119, 181, 254,7.0)'
                })
            })
        })
    ];	
	
    var manyStyle = function (radius, radius2, size) {
        return [
            new ol.style.Style({
                image: new ol.style.Circle({
                    radius: radius,
                    fill: new ol.style.Fill({
                        color: 'rgba(38, 97, 156,0.7)'
                    })
                }),
                stroke: new ol.style.Stroke({
                    color: 'red',
                    width: 3
              }),
              fill: new ol.style.Fill({
                color: 'rgba(0, 0, 255, 0.1)'
              })
            }),
            new ol.style.Style({
                image: new ol.style.Circle({
                    radius: radius2,
                    fill: new ol.style.Fill({
                        color: 'rgba(38, 97, 156,0.7)'
                    })
                }),
                text: new ol.style.Text({
                    font: '12px roboto_regular, Arial, Sans-serif',
                    text: size.toString(),
                    fill: new ol.style.Fill({
                        color: '#fff'
                    })
                })
            })
        ];
    };
	
	
    cl.legend.items.push({styles:pharmacie, label: "Pharmacie", geometry: "Point"});
    cl.legend.items.push({styles:alimentaire, label: "Alimentaire divers", geometry: "Point"});
    cl.legend.items.push({styles:supermarche, label: "Supermarché", geometry: "Point"});
    cl.legend.items.push({styles:tabac_journaux, label: "Tabac / Journaux", geometry: "Point"});
    cl.legend.items.push({styles:laverie, label: "Laverie", geometry: "Point"});
    cl.legend.items.push({styles:manyStyle(10,10,7), label: "Groupe de commerces", geometry: "Point"});

    var styleUnique = function(feature) {
        var stl;
			switch(feature.get('type')){
				case 'Pharmacie':
					stl =  pharmacie;
					break;
				case 'Alimentaire':
					stl = alimentaire;
					break;
				case 'Supermarché':
					stl = supermarche;
					break;
				case 'Tabac_journaux':
					stl = tabac_journaux;
					break;
				case 'Laverie':
					stl = laverie;
					break;
			}
        /*if(feature.get('type') === 'Pharmacie') {
            stl = pharmacie;
        } else if(feature.get('type') === 'Alimentaire') {
            stl = alimentaire;
        }*/
        return stl;
    };


    var clusterStyle = function(feature) {
        var size = feature.get('features').length;
        var max_radius = 20;
        var max_value = 100;
        var radius = 10 + Math.sqrt(size)*(max_radius / Math.sqrt(max_value));
        var radius2 = radius *80 /100 ;
        if (size == 1) 
			{
			/*var stl;
			switch(feature.get('type')){
				case 'Pharmacie':
					stl =  pharmacie;
				case 'Alimentaire':
					stl = alimentaire;
				case 'Supermarché':
					stl = supermarche;
				case 'Tabac_journaux':
					stl = tabac_journaux;
				case 'Laverie':
					stl = laverie;
			}*/
			return styleUnique(feature.getProperties().features[0]);
        } else {
            return manyStyle(radius, radius2, size);
        }
    };

    cl.layer = new ol.layer.Vector({
        source: new ol.source.Cluster({
            distance: 50,
            source: new ol.source.Vector({
				url: "https://geobretagne.fr/geoserver/osm/wfs?service=WFS&version=1.0.0&request=GetFeature&typeNames=commerces_necessite&outputFormat=application/json&srsName=EPSG:4326",
                format: new ol.format.GeoJSON()
            })
        }),
        style: clusterStyle

    });
    cl.handle = function(clusters, views) {
        if (clusters.length > 0 && clusters[0].properties.features) {
            var features = clusters[0].properties.features;
            var elements = [];
            var l = mviewer.getLayer("cluster");
            features.forEach(function(feature, i) {
                elements.push({
                    properties: feature.getProperties()
                });
            });
            var html;
            if (l.template) {
                html = info.templateHTMLContent(elements, l);
            } else {
                html = info.formatHTMLContent(elements, l);
            }
            var view = views["right-panel"];
            view.layers.push({
                "id": view.layers.length + 1,
                "firstlayer": true,
                "manyfeatures": (features.length > 1),
                "nbfeatures": features.length,
                "name": l.name,
                "layerid": "cluster",
                "theme_icon": l.icon,
                "html": html
            });
        }

    };
}